/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.ComprobanteAnulado;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.DatosDeclaracion;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.Exportacion;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.BeneficioRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Fideicomiso;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.Rendimiento;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Establecimiento;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Iva
extends ObjetoModelo
implements RaizModelo,
InformacionValidable,
Exportable,
Importable {
    private static final String PASAPORTE_EN_EXPORTACIONES = "17";
    private static final long serialVersionUID = 4937177045595709811L;
    public static final String CC_CLIENTES_VENTA = "clientesVenta";
    public static final String CC_COMPROBANTES_ANULADOS = "comprobantesAnulados";
    public static final String CC_RECAPS = "recaps";
    public static final String CC_EXPORTACION = "exportaciones";
    public static final String CC_FIDEICOMISOS = "fideicomisos";
    public static final String CC_RENDIMIENTOS = "rendimientos";
    public static final String CC_TRANSACCION_COMPRA = "transaccionCompra";
    private static final String RAIZ = "iva";
    public static final String CC_ESTABLECIMIENTOS = "establecimientos";
    public static final String C_TOTAL_VENTAS = "totalVentasInterfaz";
    public static final String C_TOTAL_REEMBOLSOS = "totalReembolsosInterfaz";
    public static final String NUM_ESTABLECIMIENTOS = "numEstabRuc";
    private DatosDeclaracion datosDeclaracion;
    private String identificacion;
    private String razonSocial;
    private final Calendar fechaPeriodoDeclarado = GregorianCalendar.getInstance();
    private BigDecimal porcentajeIva = BigDecimal.ZERO;
    private BigDecimal totalVentas = new BigDecimal("0.00");
    private BigDecimal totalReembolsos = new BigDecimal("0.00");
    private BigDecimal totalCompensaciones;
    private Date fechaRegistroContableSeleccionada = null;
    private final List<TransaccionCompra> transaccionCompra;
    private List<Venta> clientesVenta = new ArrayList<Venta>();
    private List<ComprobanteAnulado> comprobantesAnulados = new ArrayList<ComprobanteAnulado>();
    private List<Recap> recaps = new ArrayList<Recap>();
    private final List<Exportacion> exportaciones = new ArrayList<Exportacion>();
    private final List<Fideicomiso> fideicomisos = new ArrayList<Fideicomiso>();
    private final List<Rendimiento> rendimientos = new ArrayList<Rendimiento>();
    private String numEstabRuc = "0";
    private final List<Establecimiento> establecimientos;
    public Periodo periodo;

    public Iva() {
        this.transaccionCompra = new ArrayList<TransaccionCompra>();
        this.establecimientos = new ArrayList<Establecimiento>();
        this.datosDeclaracion = new DatosDeclaracion();
        this.periodo = new Periodo();
    }

    public void inicializar() {
        int anio = Util.getInteger(this.getDatosDeclaracion().getAnio());
        int mes = Util.getInteger(this.getDatosDeclaracion().getMes());
        this.periodo = new Periodo(anio, mes);
        this.fechaPeriodoDeclarado.setTime(this.periodo.getFechaDeclarada().toDate());
        this.porcentajeIva = UtilCatalogosATS.crearInstancia().obtenerPorcentajeIVA(anio, mes).multiply(Constantes.CIEN);
    }

    public boolean isMostrarReembolsos() {
        return this.periodo.isPeriodoDeAnexoDesdeMarzo2015();
    }

    public void agregarClienteVenta(Venta cliente) {
        cliente.setPropietario(this);
        this.clientesVenta.add(cliente);
        this.firePropertyChange(CC_CLIENTES_VENTA, null, this.clientesVenta);
    }

    public boolean eliminarClienteVenta(Venta cliente) {
        boolean eliminado = this.clientesVenta.remove((Object)cliente);
        if (eliminado) {
            this.actualizarTotalVentas();
            this.firePropertyChange(CC_CLIENTES_VENTA, null, this.clientesVenta);
        }
        return eliminado;
    }

    public void agregarComprobanteAnulado(ComprobanteAnulado comprobanteAnulado) {
        comprobanteAnulado.setPropietario(this);
        this.comprobantesAnulados.add(comprobanteAnulado);
        this.firePropertyChange(CC_COMPROBANTES_ANULADOS, null, this.comprobantesAnulados);
    }

    public boolean eliminarComprobanteAnulado(ComprobanteAnulado comprobanteAnulado) {
        boolean eliminado = this.comprobantesAnulados.remove((Object)comprobanteAnulado);
        if (eliminado) {
            this.firePropertyChange(CC_COMPROBANTES_ANULADOS, null, this.comprobantesAnulados);
        }
        return eliminado;
    }

    public void agregarRecap(Recap recap) {
        recap.setPropietario(this);
        this.recaps.add(recap);
        this.firePropertyChange(CC_RECAPS, null, this.recaps);
    }

    public boolean eliminarRecap(Recap recap) {
        boolean eliminado = this.recaps.remove((Object)recap);
        if (eliminado) {
            this.firePropertyChange(CC_RECAPS, null, this.recaps);
        }
        return eliminado;
    }

    public void agregarExportacion(Exportacion exportacion) {
        exportacion.setPropietario(this);
        this.exportaciones.add(exportacion);
        this.firePropertyChange(CC_EXPORTACION, null, this.exportaciones);
    }

    public boolean eliminarExportacion(Exportacion exportacion) {
        boolean eliminado = this.exportaciones.remove((Object)exportacion);
        if (eliminado) {
            this.firePropertyChange(CC_EXPORTACION, null, this.exportaciones);
        }
        return eliminado;
    }

    public void agregarAdministradorFondos(Fideicomiso fideicomiso) {
        fideicomiso.setPropietario(this);
        this.fideicomisos.add(fideicomiso);
        this.firePropertyChange(CC_FIDEICOMISOS, null, this.fideicomisos);
    }

    public boolean eliminarFdeicomiso(Fideicomiso fideicomiso) {
        boolean eliminado = this.fideicomisos.remove((Object)fideicomiso);
        if (eliminado) {
            this.firePropertyChange(CC_FIDEICOMISOS, null, this.fideicomisos);
        }
        return eliminado;
    }

    public void agregarRendimiento(Rendimiento rendimiento) {
        rendimiento.setPropietario(this);
        this.rendimientos.add(rendimiento);
        this.firePropertyChange(CC_RENDIMIENTOS, null, this.rendimientos);
    }

    public void agregarEstablecimiento(Establecimiento establecimiento) {
        establecimiento.setPropietario(this);
        this.establecimientos.add(establecimiento);
        this.setNumEstabRuc(String.valueOf(this.establecimientos.size()));
        this.firePropertyChange(CC_ESTABLECIMIENTOS, null, this.establecimientos);
    }

    public boolean eliminarEstablecimiento(Establecimiento establecimientoSeleccionado) {
        boolean eliminado = this.establecimientos.remove((Object)establecimientoSeleccionado);
        if (eliminado) {
            this.setNumEstabRuc(String.valueOf(this.establecimientos.size()));
            this.firePropertyChange(CC_ESTABLECIMIENTOS, null, this.establecimientos);
        }
        return eliminado;
    }

    public boolean eliminarRendimiento(Rendimiento rendimiento) {
        boolean eliminado = this.rendimientos.remove((Object)rendimiento);
        if (eliminado) {
            this.firePropertyChange(CC_RENDIMIENTOS, null, this.rendimientos);
        }
        return eliminado;
    }

    public void agregarTransaccionCompra(TransaccionCompra transaccionCompra) {
        transaccionCompra.setPropietario(this);
        this.transaccionCompra.add(transaccionCompra);
        this.firePropertyChange(CC_TRANSACCION_COMPRA, null, this.transaccionCompra);
    }

    public boolean eliminarTransaccionCompra(TransaccionCompra transaccionCompra) {
        boolean eliminado = this.transaccionCompra.remove((Object)transaccionCompra);
        if (eliminado) {
            this.firePropertyChange(CC_TRANSACCION_COMPRA, null, this.transaccionCompra);
        }
        return eliminado;
    }

    public String getCodigoOperativo() {
        return "IVA";
    }

    public ResultadoValidacion validar() {
        return null;
    }

    public void setListenerValidacion(ListenerValidacionInformacion listenerValidacion) {
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        this.identificacion = mapaData.get("IdInformante").getTextContent();
        this.razonSocial = mapaData.get("razonSocial").getTextContent();
        this.getDatosDeclaracion().setAnio(mapaData.get("Anio").getTextContent());
        this.getDatosDeclaracion().setMes(mapaData.get("Mes").getTextContent());
        if (mapaData.get("regimenMicroempresa") != null) {
            this.getDatosDeclaracion().setMicro(mapaData.get("regimenMicroempresa").getTextContent());
            if (mapaData.get("regimenMicroempresa").getTextContent().equals("SI")) {
                this.getDatosDeclaracion().setEsMicroEmpresa(true);
            }
        }
        this.periodo = new Periodo(Integer.parseInt(this.datosDeclaracion.getAnio()), Integer.parseInt(this.datosDeclaracion.getMes()));
        this.numEstabRuc = mapaData.get(NUM_ESTABLECIMIENTOS) == null ? "0" : mapaData.get(NUM_ESTABLECIMIENTOS).getTextContent();
        this.totalVentas = new BigDecimal(mapaData.get(NUM_ESTABLECIMIENTOS) == null ? "0.00" : mapaData.get("totalVentas").getTextContent().trim());
        return this;
    }

    public List<Venta> getClientesVenta() {
        return this.clientesVenta;
    }

    public List<ComprobanteAnulado> getComprobantesAnulados() {
        return this.comprobantesAnulados;
    }

    public List<Recap> getRecaps() {
        return this.recaps;
    }

    public List<Exportacion> getExportaciones() {
        return this.exportaciones;
    }

    public List<Fideicomiso> getFideicomisos() {
        return this.fideicomisos;
    }

    public List<Rendimiento> getRendimientos() {
        return this.rendimientos;
    }

    public List<Establecimiento> getEstablecimientos() {
        return this.establecimientos;
    }

    public List<TransaccionCompra> getTransaccionCompra() {
        return this.transaccionCompra;
    }

    public DatosDeclaracion getDatosDeclaracion() {
        return this.datosDeclaracion;
    }

    public String getIdentificacion() {
        return this.identificacion;
    }

    public String getRazonSocial() {
        return this.razonSocial;
    }

    public Calendar getFechaPeriodoDeclarado() {
        return this.fechaPeriodoDeclarado;
    }

    public BigDecimal getPorcentajeIva() {
        return this.porcentajeIva;
    }

    public BigDecimal getTotalVentas() {
        return this.totalVentas;
    }

    public BigDecimal getTotalReembolsos() {
        return this.totalReembolsos;
    }

    public String getTotalVentasInterfaz() {
        this.totalVentas = this.totalVentas.setScale(2, 6);
        return this.totalVentas.toString();
    }

    public String getTotalReembolsosInterfaz() {
        return this.totalReembolsos.toString();
    }

    public void actualizarTotalVentas() {
        this.setTotalVentas(BigDecimal.ZERO);
        this.setTotalReembolsos(BigDecimal.ZERO);
        for (Venta cliente : this.getClientesVenta()) {
            this.setTotalVentas(Util.sumar(this.getTotalVentasInterfaz(), cliente.getTotalVentaPorCliente()));
            this.setTotalReembolsos(this.getTotalReembolsos().add(Util.getBigDecimal(cliente.getTotalReembolsoPorCliente())));
        }
    }

    public void actualizarTotalCompensaciones() {
        this.setTotalCompensaciones(BigDecimal.ZERO);
        for (Venta venta : this.getClientesVenta()) {
            this.setTotalCompensaciones(this.totalCompensaciones.add(venta.getTotalCompensacionesPorCliente()));
        }
    }

    public boolean esAnexoEnRangoDe2013A2014() {
        return this.periodo.isPeridoDeAnexoDesdeEnero2013aFebrero2015();
    }

    public boolean esAnexo2015() {
        return this.periodo.isPeriodoDeAnexoDesdeMarzo2015();
    }

    public void setTotalVentas(BigDecimal totalVentas) {
        BigDecimal oldValue = this.totalVentas;
        this.totalVentas = totalVentas;
        this.firePropertyChange(C_TOTAL_VENTAS, oldValue, this.totalVentas);
    }

    public void setTotalReembolsos(BigDecimal totalReembolsos) {
        BigDecimal oldValue = this.totalReembolsos;
        this.totalReembolsos = totalReembolsos;
        this.firePropertyChange(C_TOTAL_REEMBOLSOS, oldValue, this.totalReembolsos);
    }

    public void setTotalCompensaciones(BigDecimal totalCompensaciones) {
        this.totalCompensaciones = totalCompensaciones;
    }

    public void setDatosDeclaracion(DatosDeclaracion datosDeclaracion) {
        this.datosDeclaracion = datosDeclaracion;
    }

    public void setIdentificacion(String identificacion) {
        this.identificacion = identificacion;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    public String getNumEstabRuc() {
        return this.numEstabRuc;
    }

    public BigDecimal getTotalCompensaciones() {
        return this.totalCompensaciones;
    }

    public void setNumEstabRuc(String numEstabRuc) {
        String oldValue = this.numEstabRuc;
        this.numEstabRuc = numEstabRuc;
        this.firePropertyChange(NUM_ESTABLECIMIENTOS, oldValue, this.numEstabRuc);
    }

    public Date getFechaRegistroContableSeleccionada() {
        return this.fechaRegistroContableSeleccionada;
    }

    public void setFechaRegistroContableSeleccionada(Date fechaRegistroContableSeleccionada) {
        this.fechaRegistroContableSeleccionada = fechaRegistroContableSeleccionada;
    }

    public Element exportar(Document documento, Element elemento) {
        Element rootElement = documento.createElement(RAIZ);
        documento.appendChild(rootElement);
        Element em = documento.createElement("TipoIDInformante");
        em.setTextContent("R");
        rootElement.appendChild(em);
        em = documento.createElement("IdInformante");
        em.setTextContent(this.getIdentificacion());
        rootElement.appendChild(em);
        em = documento.createElement("razonSocial");
        em.setTextContent(this.getRazonSocial());
        rootElement.appendChild(em);
        em = documento.createElement("Anio");
        em.setTextContent(this.getDatosDeclaracion().getAnio());
        rootElement.appendChild(em);
        em = documento.createElement("Mes");
        em.setTextContent(this.getDatosDeclaracion().getMes());
        rootElement.appendChild(em);
        if ("SI".equals(this.getDatosDeclaracion().getMicro())) {
            em = documento.createElement("regimenMicroempresa");
            em.setTextContent(this.getDatosDeclaracion().getMicro());
            rootElement.appendChild(em);
        }
        if (!"0".equals(this.getNumEstabRuc())) {
            em = documento.createElement(NUM_ESTABLECIMIENTOS);
            em.setTextContent(Util.getCadenaFormateada(this.getNumEstabRuc(), "3", Character.valueOf('0')));
            rootElement.appendChild(em);
        }
        em = documento.createElement("totalVentas");
        em.setTextContent(this.getTotalVentasInterfaz());
        rootElement.appendChild(em);
        em = documento.createElement("codigoOperativo");
        em.setTextContent(this.getCodigoOperativo());
        rootElement.appendChild(em);
        em = documento.createElement("compras");
        for (TransaccionCompra cpra : this.getTransaccionCompra()) {
            Element compra = cpra.exportar(documento, null);
            em.appendChild(compra);
        }
        rootElement.appendChild(em);
        em = documento.createElement("ventas");
        for (Venta cliVts : this.getClientesVenta()) {
            for (ComprobanteVenta cv : cliVts.getComprobantesVenta()) {
                Element compVts = cv.exportar(documento, null);
                em.appendChild(compVts);
            }
        }
        rootElement.appendChild(em);
        em = this.obtenerVentasEstablecimientoXml(documento);
        if (em.getChildNodes().getLength() > 0) {
            rootElement.appendChild(em);
        }
        em = documento.createElement(CC_EXPORTACION);
        for (Exportacion exp : this.getExportaciones()) {
            Element exportacion = exp.exportar(documento, null);
            em.appendChild(exportacion);
        }
        rootElement.appendChild(em);
        em = this.obtenerRecapXml(documento);
        rootElement.appendChild(em);
        em = this.exportarFideicomisos(documento);
        rootElement.appendChild(em);
        em = documento.createElement("anulados");
        for (ComprobanteAnulado ca : this.getComprobantesAnulados()) {
            Element detAnl = ca.exportar(documento, null);
            em.appendChild(detAnl);
        }
        rootElement.appendChild(em);
        em = this.obtenerRendFinancierosXml(documento);
        rootElement.appendChild(em);
        return rootElement;
    }

    private Element exportarFideicomisos(Document documento) {
        Element fideicomisos = documento.createElement(CC_FIDEICOMISOS);
        LinkedHashMap informacionBeneficiario = new LinkedHashMap();
        for (Fideicomiso fideicomiso : this.getFideicomisos()) {
            for (BeneficioRetencion ben : fideicomiso.getBeneficiosRetencion()) {
                String tipoBeneficiario = UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacion("7", ben.getBeneficiario().getTipoIdentificacion());
                String idBeneficiario = ben.getBeneficiario().getIdentificacion();
                String rucFideicomiso = fideicomiso.getRucFideicomiso();
                String parteRelacionada = ben.getParteRelacionada();
                String tipoDeProveedor = ben.getBeneficiario().getTipoProveedor();
                String razonSocial = ben.getBeneficiario().getRazonSocial();
                String beneficiario = String.valueOf(tipoBeneficiario) + "," + idBeneficiario + "," + parteRelacionada + "," + rucFideicomiso + "," + tipoDeProveedor + "," + razonSocial;
                Element grupoFideicomiso = documento.createElement("detallefValor");
                Element ax = documento.createElement("tipoFideicomiso");
                ax.setTextContent(fideicomiso.getTipoFideicomiso());
                grupoFideicomiso.appendChild(ax);
                ax = documento.createElement("totalF");
                ax.setTextContent(fideicomiso.getMontoBeneficioTotal());
                grupoFideicomiso.appendChild(ax);
                ax = documento.createElement("individualF");
                ax.setTextContent(ben.getMontoBeneficioIndividual());
                grupoFideicomiso.appendChild(ax);
                ax = documento.createElement("porRetF");
                ax.setTextContent(ben.getPorcentajeRetencion());
                grupoFideicomiso.appendChild(ax);
                ax = documento.createElement("valorRetF");
                ax.setTextContent(ben.getMontoRentencionRenta());
                grupoFideicomiso.appendChild(ax);
                if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
                    ax = documento.createElement("fechaPagoDiv");
                    ax.setTextContent(Util.dateToStringWithFormat(ben.getFechaPagoDiv(), Constantes.FORMATO_FECHA.toPattern()));
                    grupoFideicomiso.appendChild(ax);
                    ax = documento.createElement("imRentaSoc");
                    ax.setTextContent(ben.getImpRentSoc());
                    grupoFideicomiso.appendChild(ax);
                    ax = documento.createElement("anioUtDiv");
                    ax.setTextContent(ben.getAnioGerUtilDiv());
                    grupoFideicomiso.appendChild(ax);
                }
                if (ben.getPagoLocalExterior() != null && this.esAnexoEnRangoDe2013A2014() | this.esAnexo2015()) {
                    ax = ben.getPagoLocalExterior().exportar(documento, null);
                    grupoFideicomiso.appendChild(ax);
                }
                if (informacionBeneficiario.get(beneficiario) == null) {
                    LinkedList<Element> lst = new LinkedList<Element>();
                    lst.add(grupoFideicomiso);
                    informacionBeneficiario.put(beneficiario, lst);
                    continue;
                }
                ((LinkedList)informacionBeneficiario.get(beneficiario)).add(grupoFideicomiso);
            }
        }
        for (Map.Entry entry : informacionBeneficiario.entrySet()) {
            String[] beneficiario = ((String)entry.getKey()).split(",");
            Element detFid = documento.createElement("detalleFideicomisos");
            Element em = documento.createElement("tipoBeneficiario");
            em.setTextContent(beneficiario[0]);
            detFid.appendChild(em);
            em = documento.createElement("idBeneficiario");
            em.setTextContent(beneficiario[1]);
            detFid.appendChild(em);
            if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
                em = documento.createElement("parteRelExp");
                em.setTextContent(beneficiario[2]);
                detFid.appendChild(em);
            }
            if (this.periodo.isAnexoEnPeriodoDesdeMayo2016() && beneficiario[0].equals(PASAPORTE_EN_EXPORTACIONES)) {
                em = documento.createElement("tipoBeneficiarioCli");
                em.setTextContent(beneficiario[4]);
                detFid.appendChild(em);
                em = documento.createElement("denoBenefi");
                em.setTextContent(beneficiario[5]);
                detFid.appendChild(em);
            }
            em = documento.createElement("rucFideicomiso");
            em.setTextContent(beneficiario[3]);
            detFid.appendChild(em);
            em = documento.createElement("fValor");
            for (Element ele : (LinkedList)entry.getValue()) {
                em.appendChild(ele);
            }
            detFid.appendChild(em);
            fideicomisos.appendChild(detFid);
        }
        return fideicomisos;
    }

    private Element obtenerVentasEstablecimientoXml(Document documento) {
        Element ventasEstablecimiento = documento.createElement("ventasEstablecimiento");
        for (Establecimiento est : this.getEstablecimientos()) {
            Element ventaEst = est.exportar(documento, null);
            ventasEstablecimiento.appendChild(ventaEst);
        }
        return ventasEstablecimiento;
    }

    private Element obtenerRecapXml(Document documento) {
        Element eleRecap = documento.createElement("recap");
        for (Recap rc : this.getRecaps()) {
            Element emRc = rc.exportar(documento, null);
            eleRecap.appendChild(emRc);
        }
        return eleRecap;
    }

    private Element obtenerRendFinancierosXml(Document documento) {
        Element rendFinancieros = documento.createElement("rendFinancieros");
        for (Rendimiento rdm : this.getRendimientos()) {
            Element detRedFin = rdm.exportar(documento, null);
            rendFinancieros.appendChild(detRedFin);
        }
        return rendFinancieros;
    }
}

